import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import InterventoForm from "../../../../core/Forms/InterventoForm/InterventoForm";
import {interventoQuery} from "../../../../api/queries";
import {Button, Card, CardBody, CardText, CardTitle} from "reactstrap";
import AcquaticaDrop from "../../../../core/AcquaticaDrop";
import Loading from "../../../../core/Loading/Loading";
import moment from 'moment';
import 'moment/locale/it';
import {findById} from "../../../../utils";
import ReactTable from "react-table";
import Ionicon from "react-ionicons";

class Detail extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
    }

    componentWillMount() {
        moment.locale("it");
    }

    renderVariablePart(intervento) {
        var source = [
            {
                label:'Sezione 1',
                children:[
                    {id:'field_1', label:'Campo 1', value:'x'},
                    {id:'field_2', label:'Campo 2', value:'Lorem ipsum'}
                ]
            },
            {
                label:'Sezione 2',
                children:[
                    {id:'field_3', label:'Campo 3', value:'yyy'}
                ]
            }
        ]

        var i = JSON.parse(intervento.info)
        console.log(i)

        return (
            <div>
                {i.filter(item=>{return !item.hidden && (!item.solotipo || item.solotipo==intervento.tipo) && (!item.solosottotipo || item.solosottotipo.indexOf(intervento.sottotipo)!==-1) }).map(section => 
                <div>
				
		{section.label && <div className="row">
                        <div className="col">
                            <h5>{section.label}</h5>
                        </div>
                    </div>
		}
                    {section.children.map(field => 
                        <div>
                            <dl className="row">
                                <dt className="col-sm-3">
                                    {field.label}
                                </dt>
                                <dd className="col-sm-9">
                                    {field.type=='checkbox'? (field.value?'SI':'NO') : field.value}
                                </dd>
                            </dl>
                        </div>
                    )

                    }
                </div>

                )}
            </div>
        )
    }

    render() {
        const {data} = this.props;

        if(data.loading) {
            return(<Loading/>);
        }

        const {
            intervento,
            specieProgettos
        } = data;

        const specieProgetto = findById(specieProgettos, intervento.specie.id);

        return (<div className="container" style={{marginBottom: '20px'}}>
            <div className="row">
                <div className="col">
                    <div className="form-group">
                        <label htmlFor="specie">Specie</label>
                        <Card>
                            <CardBody style={{backgroundColor: "#ffffff"}}>
                                {intervento.specie && <CardTitle className="ionicon-center">
				    <img src={'/LifeEremitaWeb/specie/'+intervento.specie.id+'.png'} style={{'marginRight':'2em'}} />
                                    {intervento.specie.denominazioneTaxon}
                                    {<AcquaticaDrop containerStyle={{marginLeft: '0.2em'}} acquatica={specieProgetto.acquatica} specieId={specieProgetto.id}/>}
                                </CardTitle>}

                                {!intervento.specie && <CardText>
                                    Specie non indicata
                                </CardText>}
                            </CardBody>
                        </Card>
                    </div>
                </div>
            </div>
            <div>
                <div className="row">
                    <div className="col">
                        
                    </div>
                </div>

		<dl className="row">
                    <dt className="col-sm-3">
                        Tipologia intervento
                    </dt>
                    <dd className="col-sm-9">
                        {intervento.tipo=='habitat'?'Interventi sugli habitat':''}
			{intervento.tipo=='prelievo'?'Prelievi/immissioni':''}
			{intervento.tipo=='captive'?'Captive breeding':''}
                    </dd>
                </dl>

		{intervento.tipo=='habitat' &&
		<dl className="row">
                    <dt className="col-sm-3">
                        Tipologia habitat
                    </dt>
                    <dd className="col-sm-9">
                        {intervento.sottotipo=='albero'?'Albero':''}
			{intervento.sottotipo=='lentica'?'Zona umida lentica':''}
			{intervento.sottotipo=='lotica'?'Zona umida lotica':''}
                    </dd>
                </dl>
		}

		<dl className="row">
                    <dt className="col-sm-3">
			{intervento.tipo=='prelievo' && 'ID esemplare'}
                       {intervento.tipo=='captive' && 'ID controllo box'}
		{intervento.tipo=='habitat' && 'ID intervento'}
                    </dt>
                    <dd className="col-sm-9">
                        {intervento.idScheda}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Sito Natura 2000
                    </dt>
                    <dd className="col-sm-9">
                        {intervento.sitoNatura2000 && intervento.sitoNatura2000.nome}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Compilatore
                    </dt>
                    <dd className="col-sm-9">
                        {intervento.rilevatori}
                    </dd>
                </dl>



                
            </div>
            {this.renderVariablePart(intervento)}

	    <div className="row">
                    <div className="col">
                        <h5>Allegati all'Intervento</h5>
                    </div>
                </div>

                <ReactTable
                    loading={data.loading}
                    noDataText={"Nessun documento presente"}
                    className="-highlight"
                    data={intervento.documenti}
                    style={{maxHeight: "300px"}}
                    defaultPageSize={10}
                    nextText="Avanti"
                    previousText="Indietro"
                    loadingText="Caricamento in corso..."
                    rowsText="elementi"
                    ofText="di"
                    pageText="Pagina"
                    columns={[
                        {
                            Header: "Nome File",
                            accessor: "nomeFile",
                        },
			{
			     Header: "Scarica",
		  	     Cell: (row) => (
				      <div style={{display: 'flex', alignItems: 'center'}}>
            				  <div className="btn-group btn-group-sm" style={{margin: '0 auto'}}>
            				    <Button className="btn ionicon-btn btn-light" onClick={() => window.open('/LifeEremitaWeb/download/'+row.original.uuid)}>
          				        <Ionicon icon="ios-download-outline" />
          				      </Button>
           				   </div>
         			     </div>
			     )
			   }
                    ]} />
        </div>);
    }
}

export default compose(
    graphql(interventoQuery, {
        options:({match}) => ({variables: {id: match.params.id}}),
    }),
)(Detail);

Detail.defaultProps = {};

Detail.propTypes = {};

